<?php

use \UtillzCore\Inc\Src\Woocommerce\Packages\Promotion;

global $ulz_package;

// package
$promotion = new Promotion( (int) $ulz_package->get_id() );
if( ! $promotion->id ) {
    return;
}

?>

<label class="ulz-package">
    <div class="ulz--radio">
        <input type="radio" name="package_id" value="<?php echo (int) $ulz_package->get_id(); ?>">
        <span></span>
    </div>
    <div class="ulz--image">
        <?php if( $ulz_package->get_image_id() ): ?>
            <?php echo wp_kses_post( $ulz_package->get_image('thumbnail') ); ?>
        <?php else: ?>
            <?php echo Ucore()->dummy('fas fa-toolbox', 'font-awesome', 100 ); ?>
        <?php endif; ?>
    </div>
    <div class="ulz--content">
        <h4 class="ulz--title"><?php echo $ulz_package->get_name() ?></h4>
        <?php $duration = $promotion->get_duration(); ?>
        <?php $price = sprintf( get_woocommerce_price_format(), get_woocommerce_currency_symbol(), $ulz_package->get_price() ); ?>
        <?php if( $duration <= 0 ): ?>
            <p><?php echo sprintf( esc_html__( '%s, promotion lasts for unlimited days', 'utillz-core' ), $price, $duration ); ?></p>
        <?php else: ?>
            <p><?php echo sprintf( _n( '%s, promotion lasts for %s day', '%s, promotion lasts for %s days', $duration, 'utillz-core' ), $price, $duration ); ?></p>
        <?php endif; ?>
    </div>
    <div class="ulz--action">
        <span class="ulz-button"><?php esc_html_e( 'Select', 'utillz-core' ); ?></span>
    </div>
</label>
